﻿namespace Hims.Api.Models.InternalMedicine
{
    using System.Collections.Generic;
    using Hims.Shared.Library.Enums;

    /// <summary>
    /// The encounter images.
    /// </summary>
    public class EncounterImages
    {
        /// <summary>
        /// Gets or sets the images.
        /// </summary>
        public List<SkinTypes> Images { get; set; }

        /// <summary>
        /// Gets or sets the json string.
        /// </summary>
        public string JsonString { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int? EncounterId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public InternalMedicine Type { get; set; }
    }
}
